#ifndef __MT_TXMP_VIEWER_H__
#define __MT_TXMP_VIEWER_H__

#include "MTGrafPortWindow.h"
#include "MTUtilities.h"
#include "MTInfoWindow.h"
#include "MTFileList.h"
#include "MTViewer.h"

class MTTXMPHandler
{
	public:
				MTTXMPHandler();
				~MTTXMPHandler();
		
		void	ParseData(UInt8 * buf, UInt32 size);
		
		void	CopyFromGWorld(GWorldPtr theWorld);
		
		void	DrawToBuffer(UInt8 * pixBaseAddr, UInt32 rowBytes, UInt32 inDepth);
		void	DrawToPort(GWorldPtr theWorld, UInt32 xOffset, UInt32 yOffset);
		
		void	AttachFileList(MTFileList * inList)	{ fileList = inList; }
		
		UInt32		id;
		UInt32		unknown1;
		UInt32		unknown2;
		UInt16		width;
		UInt16		height;
		UInt32		format;
		UInt32		unknown4;
		UInt32		unknown5;
		UInt32		unknown6;
		UInt32		dataOffset;
		UInt32		unknown7;
		
		std::string	name;
		
		UInt32		dataSize;
		UInt32		depth;
		
		MTFileList	* fileList;
};

class MTTXMPViewer : public MTGrafPortWindow, public MTViewer
{
	public:
						MTTXMPViewer();
						~MTTXMPViewer();
		
		void			ParseData(UInt8 * buf, UInt32 size);
		
		void			GetWindowName(StringPtr theString);
		
		void			RecieveMessage(UInt32 messageType, UInt32 messageData);
		UInt8			SupportsMessage(UInt32 messageType, UInt32 messageData);
	
	protected:
		void			GetPortSize(UInt32 * inWidth, UInt32 * inHeight)	{ *inWidth = handler.width; *inHeight = handler.height; }
		UInt32			GetPortDepth(void)									{ return handler.depth; }
		
		void			DrawToPort(GWorldPtr theWorld);
	
	private:
		void			DoExportRaw(void);
		void			DoImport(void);
		
		void			SpawnInfoWindow(void);
		
		MTTXMPHandler	handler;
		
		static MTInfoWindowDataTemplate	kInfoWindowTemplate;
};

#endif /* __MT_TXMP_VIEWER_H__ */